
#ifndef _1_CRYS_ATP_TST_AES_Acceptance_h_H
#define _1_CRYS_ATP_TST_AES_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"

#if TST_USE_AES_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 30 10:18:14 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_AES_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
typedef struct TST_AES_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CRYS_AES_Key_t 				TST_Key;
	CRYS_AES_KeySize_t			TST_KeySize;
	CRYS_AES_IvCounter_t		TST_IvCounter;
	DxUint8_t 					TST_input_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_Expected_output_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;	
	CRYS_AES_OperationMode_t	TST_OperationMode;
} TST_AES_TestDataStruct;

#if TST_USE_SECRETKEY_TESTS
typedef struct TST_AES_SecreteKeyTestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CRYS_AES_IvCounter_t		TST_IvCounter;
	DxUint8_t 					TST_input_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_Expected_output_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;	
	CRYS_AES_OperationMode_t	TST_OperationMode;
} TST_AES_SecreteKeyTestDataStruct;
#endif

typedef struct TST_AES_MAC_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CRYS_AES_Key_t 				TST_Key;
	CRYS_AES_KeySize_t			TST_KeySize;
	CRYS_AES_IvCounter_t		TST_IvCounter;
	DxUint8_t 					TST_input_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;
	DxUint8_t 					TST_Expected_CBC_MAC[TST_CBC_MAC_SIZE];
	CRYS_AES_OperationMode_t	TST_OperationMode;
} TST_AES_MAC_TestDataStruct;

typedef struct TST_AES_KeyWrap_TestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    CRYS_AES_Key_t 				TST_Key;
    CRYS_AES_KeySize_t			TST_KeySize;
    DxUint8_t 					TST_InputData[TST_AES_DATA_VEC_SIZE_IN_BYTS];
    DxUint16_t 					TST_InputDataSize;
    DxUint8_t 					TST_WrapdData[TST_AES_DATA_VEC_SIZE_IN_BYTS];
    DxUint16_t 					TST_WrapdDataSize;
    DxUint8_t 					TST_ExpectedWrapedData[TST_AES_DATA_VEC_SIZE_IN_BYTS];
    DxUint8_t 					TST_OutputData[TST_AES_DATA_VEC_SIZE_IN_BYTS];
} TST_AES_KeyWrap_TestDataStruct;

typedef struct TST_AES_XTS_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CRYS_AES_Key_t 				TST_Key;
	CRYS_AES_KeySize_t			TST_KeySize;
	CRYS_AES_XTS_Tweak_t		TST_Tweak;
	DxUint8_t 					TST_input_data[(TST_AES_DATA_VEC_SIZE_IN_BYTS+TST_XTS_FINISH_INPUT_MAX_SIZE)];
	DxUint8_t 					TST_output_data[(TST_AES_DATA_VEC_SIZE_IN_BYTS+TST_XTS_FINISH_INPUT_MAX_SIZE)];
	DxUint8_t 					TST_Expected_output_data[(TST_AES_DATA_VEC_SIZE_IN_BYTS+TST_XTS_FINISH_INPUT_MAX_SIZE)];
	DxUint16_t					TST_dataSize;
	DxUint8_t					TST_FinishInputData[TST_XTS_FINISH_INPUT_MAX_SIZE];
	DxUint8_t					TST_FinishOutputData[TST_XTS_FINISH_INPUT_MAX_SIZE];
	DxUint8_t					TST_FinishExpectedOutputData[TST_XTS_FINISH_INPUT_MAX_SIZE];
	DxUint16_t					TST_FinishInputDataSize;
	
} TST_AES_XTS_TestDataStruct;

#ifndef CRYS_NO_AESCCM_SUPPORT
typedef struct TST_AES_CCM_TestDataStruct{  
  char                         TST_Name[TST_NAME_STRING_LEN];
  CRYS_AESCCM_Key_t            CCM_Key;   /*AESCCM key*/            
  DxUint8_t                    AdataData[512]; /*additional data buffer*/
  DxUint32_t                   AdataSize; /*full size of Adata*/
  DxUint8_t                    TextData[1024]; /*text data buffer*/
  DxUint32_t                   TextdataInputSize;/*data input size*/
  DxUint8_t                    QFieldSize;/*size of Q field in control block*/
  DxUint8_t                    N_ptr[13];     /*Nonce*/
  DxUint8_t                    SizeOfN;   /*size of N buffer*/
  DxUint8_t                    SizeOfT;    /*size of CCM-MAC (T) */
  DxUint8_t                    OutputData[(TST_AES_DATA_VEC_SIZE_IN_BYTS)];/* output data*/
  DxUint32_t                   OutputDataSize;/*data output size*/
  DxUint8_t                    ExpectedOutputData[(TST_AES_DATA_VEC_SIZE_IN_BYTS)];/*expected data */
  DxUint8_t                    OutputDataForDecrypt[(TST_AES_DATA_VEC_SIZE_IN_BYTS)];
} TST_AES_CCM_TestDataStruct;
#endif /*CRYS_NO_AESCCM_SUPPORT*/

/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_AES_Acceptance_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for AES non integrated API's							
 * 	This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - CBC/EBC/CTR  
 * 	Vector sizes used (in bytes) - 16/32/512/1536									
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_AES_Init function to start the encryption/decryption process
 * 2. Call the CRYS_AES_Block - This function is called N times
 *                              (N = number of blocks in data each block is 16byte)
 * 3. Call the CRYS_AES_Free to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one													
 *
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_AES_Acceptance_NON_integrated ( void );

/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_AES_Acceptance_Integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for AES integrated API							
 * 	This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - CBC/EBC/CTR  
 * 	Vector sizes used (in bytes) - 16/32/512/1536								
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_AES function to use the AES encryption/decryption process
 * 2. Compare the outputted result to the expected one													
 *
 ******************************************************************************/	
CRYSError_t CRYS_ATP_TST_AES_Acceptance_Integrated ( void );

/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_AES_Acceptance_MAC_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for AES non integrated API's							
 * 	This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - MAC  
 * 	Vector sizes used (in bytes) - 16/32/512/1536								
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_AES_Init function to start the encryption/decryption process
 * 2. Call the CRYS_AES_Block - This function is called N times
 *                              (N = number of blocks in data each block is 16byte)
 * 3. Call the CRYS_AES_Free to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one													
 *
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_AES_Acceptance_MAC_NON_integrated ( void );
/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for AES non integrated API's	
 *  with the new XCBC and CMAC options
 * 	This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - MAC-XCBC/CMAC  
 * 	Vector sizes used (in bytes) - 16/32/512/1536								
 * 	Key Size used (in bits)	    - 128								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_AES_Init_XCBCandCMAC function to start the encryption/decryption process
 * 2. Call the CRYS_AES_Block - This function is called N times 
 *                              (N = number of blocks in data each block is 16byte) 
 * 3. Call the CRYS_AES_XCBCandCMAC_Finish to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one   
 *
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_NON_integrated ( void );
/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for AES non integrated API's                         
*  This function Encrypts and Decrypts known vectors using AES new modes
*  XCBC and CMAC
*  AES modes                   - XCBX/CMAC   
*  Vector sizes used (in bytes) - 16/32/512/1536                     
*  Key Size used (in bits)     - 128/192 CMAC only/256 CMAC only
*  
*  This also outputs the results to an output buffer or the same input buffer
* Algorithm:       
* 1. Call the CRYS_AES_XCBCandCMAC function to start the HASH process
* 2. Compare the outputted result to the expected one                                                   
*
******************************************************************************/
CRYSError_t CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_integrated ( void ) ;
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_AES_Acceptance_MAC_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - MAC/XCBC/CMAC   
 *  Vector sizes used (in bytes) - 16/32/512/1536                           
 *  Key Size used (in bits)     - 128/192(MAC only)/256(MAC only)
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the CRYS_AES_Init function to start the encryption/decryption process
 * 2. Compare the outputted result to the expected one                                                   
 *
 ******************************************************************************/

CRYSError_t CRYS_ATP_TST_AES_Acceptance_MAC_integrated ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_AES_Acceptance_KeyWrapUnwarp      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for AES wrap unwrap  API's
*  This function wraps and unwraps known vectors using AES
*  Vector sizes used (in bytes) - 16/32/512                                 
*  Key Size used (in bits)     - 128/192/256                               
* Algorithm:       
* 1. Call the CRYS_Wrap and Unwrap function to use the AES wrap/unwrap process
* 2. Compare the outputted result to the expected one                                                      
*
******************************************************************************/    
CRYSError_t CRYS_ATP_TST_AES_Acceptance_KeyWrapUnwarp ( void ) ;

#if TST_USE_SECRETKEY_TESTS
/*****************************************************************************
* Function Name:
*  CRYS_ATP_TST_AES_Acceptance_SK
*
* Inputs:
*  None
*
* Outputs:
*  CRYSError_t - Function error return
*
* Description:
*  This function Is an acceptance test for AES using the Secret key API's
*  This function encrypts and then decrypts known vectors using AES  
*  and then verifies that the result is the same as the input.
*  AES modes                    - CBC/ECB
*  Vector sizes used (in bytes) - 16/32/512/1536
*  Key used                     - Internal 128 bit
*  This also outputs the results to an output buffer or the same input buffer
* Algorithm:
* 1. Call the CRYS_AES_SecretInit function to start the encryption process
* 2. Call the CRYS_AES_Block - This function is called N times
*                              (N = number of blocks in data each block is 16byte)
* 3. Call the CRYS_AES_Free to end the encryption process
* 4. Call The CRYS_AES_SecretKey to decrypt the output of the encryption process.
*    The decrypt operation in done in one block.
* 5. Compare the outputted result to the initial inputed one one
*
******************************************************************************/
CRYSError_t CRYS_ATP_TST_AES_Acceptance_SK( void );
#endif /*TST_USE_SECRETKEY_TESTS*/

#if TST_USE_PREDEFINED_SECRETKEY_TESTS
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_AES_Predefined_SecretKey       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES integrated API                           
 *  This function Encrypts and Decrypts known vectors using AES secret key
 *  This test will pass only if the Secret key was programed to a pre-defined value!
 *
 *  AES modes                   - CBC/ECB
 *  Vector sizes used (in bytes) - 16/32/512                                 
 *  Key Size used (in bits)     - Secret Key                                
 *  This also outputs the results to an output buffer or the same input buffer
 *      
 * Algorithm:		
 * 1. Call the CRYS_AES function to use the AES encryption/decryption process
 * 2. Compare the outputted result to the expected one	                                            
 *
 ******************************************************************************/    
CRYSError_t CRYS_ATP_TST_AES_Predefined_SecretKey ( void );
#endif /*TST_USE_PREDEFINED_SECRETKEY_TESTS*/

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_AES_XTS_Acceptance_NON_integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for AES XTS non integrated API's                         
*  This function Encrypts and Decrypts known vectors using AES
*  AES modes                   - CRYS_AES_XTS_mode   
*  Tweak sizes used (in bytes) - 16                                 
*  Key Size used (in bits)     - 256/512                               
*  
* Algorithm:       
* 1. Call the CRYS_AES_XTS_Init function to start the encryption/decryption process
* 2. Call the CRYS_AES_Block - This function is called N times 
*                              (N = number of blocks in data each block is 16byte) 
* 3. Call the CRYS_AES_XTS_Finish to end the encryption/decryption process 
* 4. Compare the outputted result to the expected one                                                   
*
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_AES_XTS_Acceptance_NON_integrated ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_AES_XTS_Acceptance_Integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for AES XTS non integrated API's                         
*  This function Encrypts and Decrypts known vectors using AES
*  AES modes                   - CRYS_AES_XTS_mode   
*  Tweak sizes used (in bytes) - 16                                 
*  Key Size used (in bits)     - 256/512                               
*  
* Algorithm:       
* 1. Call the CRYS_AES_XTS function to encrypt/decrypt data
* 2. Compare the outputted result to the expected one                                                    
*
******************************************************************************/    
CRYSError_t CRYS_ATP_TST_AES_XTS_Acceptance_Integrated ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_AES_CCM_Acceptance_Non_Integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is an Acceptance test for AES CCM non integrated API's                         
*  This function Encrypts and Decrypts known vectors using AES_CCM
*  AES modes                   - CRYS_AES_CCM_mode   
*  Key sizes used (in bytes) - 16                                 
*  Adata Size used (in bytes)- 16/500
*  Text data size( in bytes)- 16/500/1024
*  Nonce size ( in bytes) - 7 - 13 
*  T mac ( in bytes) - 4/6/8/10/12/14
*  Q fields( in bytes)- 2/3/4/8

* Algorithm:       
* 1. Call the CRYS_AES_CCM_init to init the context
* 2. Call the CRYS_AESCCM_BlockAdata function.
* 3. Copy the input buffer to the output buffer
* 4. Call the CRYS_AESCCM_BlockText data function, without the last block
* 5. Call the CRYS_AESCCM_BlockLastTextData function.
* 6. Call the CRYS_AESCCM_Finish function
* 7. Compare the output data to the expected data
******************************************************************************/    
CRYSError_t CRYS_ATP_TST_AES_CCM_Acceptance_NON_integrated ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_AES_CCM_Acceptance_Integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for AES CCM integrated API's                         
*  This function Encrypts and Decrypts known vectors using AES_CCM
*  AES modes                   - CRYS_AES_CCM_mode   
*  Key sizes used (in bytes) - 16                                 
*  Adata Size used (in bytes)- 16/500
*  Text data size( in bytes)- 16/500/1024
*  Nonce size ( in bytes) - 7 - 13 
*  T mac ( in bytes) - 4/6/8/10/12/14
*  Q fields( in bytes)- 2/3/4/8

* Algorithm:       
* 1. Call the CRYS_AES_CCM function to encrypt/decrypt data
* 2. Compare the outputted result to the expected one  
******************************************************************************/   
CRYSError_t CRYS_ATP_TST_AES_CCM_Acceptance_Integrated ( void );

#ifdef __cplusplus
}
#endif

#endif

#endif

